# 复旦数学科学学院研究生毕业论文LaTeX模版使用说明

本模版是基于开源模版[fduthesis](https://github.com/stone-zeng/fduthesis)开发的复旦大学数学科学学院研究生毕业论文 LaTeX 模版，由复旦大学数学科学学院2021级罗心悦同学整理完成。部分内容摘自复旦大学数学科学学院2023年毕业生邹森博士的毕业论文。说明性文字参考了[上海交通大学学位论文模版](https://github.com/sjtug/SJTUThesis)。该模版旨在帮助复旦大学数学科学学院的研究生规范撰写毕业论文，符合学院的格式要求。

## 使用方法

1. 下载模版文件：从数学科学学院官网下载文件"fduMaththesis.zip"
2. 编写论文内容：使用TeX编辑器打开主文件main.tex，根据自己的需要修改论文的标题、作者、摘要、章节内容等
3. 编译生成论文：使用LaTeX编译引擎（如XeLaTeX或pdfLaTeX）编译主文件main.tex，生成PDF格式的论文
4. 查看论文结果：编译成功后，会生成论文的PDF文件，可以使用PDF阅读器查看和检查论文的格式和内容

## 问题与解决方案更新

### 字体相关问题
1. 如出现字体警告: `Package fontspec Warning: Font "FandolSong-Regular" does not contain requested Script "CJK"`，可以考虑在 `./docs/setup.tex` 中进行修改，配置字体。具体地，在fdusetup的子选项style中添加命令：
```latex
cjk-font = (*<adobe(fandol)|founder|mac|sinotype|sourcehan|windows|none>*)
```
感谢21级周同学的反馈及建议。

2. 对于一些生僻字，可以通过导入特定字体库并使用 `\CJKfontspec` 命令来显示：
```latex
{\CJKfontspec{simsun.ttc} 珣}
```
感谢21级史同学的反馈及建议。



## 论文应当避免的问题

### 论文格式
   - 《复旦大学博士、硕士学位论文规范（2017.03修订版）》规定第一章应为"引言（前言）"，而非"绪论"，相关规范详见[研究生院官网](https://gs.fudan.edu.cn/6b/9f/c2806a27551/page.htm)
   - 每章从奇数页开始
   - 有编号的数学式子必须有实质性引用
   - 各章节篇幅要适中，避免过长或过短
   - 论文标题应简洁明确，目录清晰
   - 引用格式应统一（方程、定理等）
   - 参考文献按出现次序排列
   - 附录内容应在正文中有引用
   - 图表应美观易懂，必要时添加说明性标题
   - 排版规范，避免大片空白

### 论文内容

需要注意，学位论文不是期刊论文的拼凑，要有最后一章：“结论与展望”。往届很多学位论文，只有引言，后面分章是2-3篇期刊论文的具体数学内容，略去了“结论与展望”。

- 在摘要部分，应明确标识本文的主要贡献并注明相关的定理编号。这样可以帮助审稿人和读者快速了解文章的核心内容，并能在正文中迅速找到主要结果
- 使用已经发表的图片时，无论是自己的期刊论文还是他人的，都应在学位论文中明确注明图片的来源
- 论文叙述语言应流畅通顺, 叙述语言层次分明且推理严谨
- 关键学术概念和符号定义应准确规范, 符号应避免重复定义
- 对于已经在期刊论文中发表的结果，应在学位论文中明确标注并引用相应的文献
- 论文应明确工作贡献和创新点, 同时论证其与其他研究成果的差异性
- 文献综述应全面展示研究现状与价值
- 公式及定理等应书写规范、整齐, 正确引用其他研究人员资料且注明来源
- 中英文互译需与国际惯例一致, 必要时可查数学词典确认
- 参考文献要全面系统地支持重要论点。数量根据论文类型控制在50-100篇

### 研究工作
   - 研究方法应具创新性和可行性
   - 研究路径设计要全面、系统, 而非停留在探讨层面
   - 推导过程及论证应严谨精确, 避免错误或不完整之处
   - 模型和算法假设设置需要明确依据支持，应避免模型简化、目标函数选择不恰当，或者更改设定后模型正确性存疑的情况
   - 注意对问题基本性质的论证，如解的存在性、唯一性、稳定性

以上内容整理自往年毕业论文盲审评语。

